﻿Imports System.ComponentModel
Imports System.Windows.Media

Namespace LinqToXmlDataBinding

    Partial Public Class Window1
        Inherits System.Windows.Window

        Private previousBrush As Brush

        Public Sub Window1()
            Try
                Me.InitializeComponent()
            Catch ex As Exception
                MsgBox(ex.ToString())
            End Try

        End Sub

        ''' <summary>
        ''' 关闭时保存 MyFavorites 列表。
        ''' </summary>
        Protected Overrides Sub OnClosing(ByVal args As CancelEventArgs)
            Dim myFavorites = CType(CType(Resources("MyFavoritesList"), ObjectDataProvider).Data, XElement)
            myFavorites.Save("..\data\MyFavorites.xml")
        End Sub

        ''' <summary>
        ''' 播放按钮事件处理程序
        ''' </summary>
        Sub OnPlay(ByVal sender As Object, ByVal e As EventArgs)
            videoImage.Visibility = Visibility.Hidden
            mediaElement.Play()
        End Sub


        ''' <summary>
        ''' 停止按钮事件处理程序
        ''' </summary>
        Sub OnStop(ByVal sender As Object, ByVal e As EventArgs)
            mediaElement.Stop()
            videoImage.Visibility = Visibility.Visible
        End Sub


        ''' <summary>
        ''' 添加按钮事件处理程序，用于将当前选中的视频添加到 MyFavorites 中
        ''' </summary>
        Sub OnAdd(ByVal sender As Object, ByVal e As EventArgs)
            Dim itemsList = CType(CType(Resources("MyFavoritesList"), ObjectDataProvider).Data, XElement)
            itemsList.Add(CType(videoListBox1.SelectedItem, XElement))
        End Sub


        '''' <summary>
        '''' 删除按钮事件处理程序，用于从 MyFavorites 中删除当前选中的视频
        '''' </summary>
        Sub OnDelete(ByVal sender As Object, ByVal e As EventArgs)
            Dim selectedItem = CType(videoListBox2.SelectedItem, XElement)
            If (Not selectedItem Is Nothing) Then
                If selectedItem.PreviousNode IsNot Nothing Then
                    Me.videoListBox2.SelectedItem = selectedItem.PreviousNode
                ElseIf (selectedItem.NextNode Is Nothing) Then
                    Me.videoListBox2.SelectedItem = selectedItem.NextNode
                    selectedItem.Remove()
                End If
            End If
        End Sub

        ''' <summary>
        ''' 搜索框事件处理程序，用于按用户指定的输入搜索视频
        ''' </summary>
        Private Overloads Sub OnKeyUp(ByVal sender As Object, ByVal e As KeyEventArgs)
            If (e.Key.Equals(Key.Enter)) Then
                Dim objectDataProvider = CType(Resources("MsnVideosList"), ObjectDataProvider)
                objectDataProvider.MethodParameters(0) = "http://soapbox.msn.com/rss.aspx?searchTerm=" & searchBox.Text
                objectDataProvider.Refresh()
            End If
        End Sub

        ''' <summary>
        ''' 搜索选项的事件处理程序列在第一页，只须更新静态资源
        ''' 用新参数执行“MsnVideosList”，然后对其进行刷新。
        ''' </summary>
        Private Overloads Sub OnMouseUp(ByVal sender As Object, ByVal e As System.Windows.Input.MouseButtonEventArgs)
            Dim content = CType(CType(sender, Label).Content, String)
            Dim objectDataProvider = CType(Resources("MsnVideosList"), ObjectDataProvider)
            Select Case (content)
                Case "Most Viewed"
                    objectDataProvider.MethodParameters(0) = "http://soapbox.msn.com/rss.aspx?listId=MostPopular"
                    objectDataProvider.Refresh()
                Case "Most Recent"
                    objectDataProvider.MethodParameters(0) = "http://soapbox.msn.com/rss.aspx?listId=MostRecent"
                    objectDataProvider.Refresh()
                Case "Top Favorites"
                    objectDataProvider.MethodParameters(0) = "http://soapbox.msn.com/rss.aspx?listId=TopFavorites"
                    objectDataProvider.Refresh()
                Case "Top Rated"
                    objectDataProvider.MethodParameters(0) = "http://soapbox.msn.com/rss.aspx?listId=TopRated"
                    objectDataProvider.Refresh()
                Case "My Favorites"
                    Dim msn = CType(objectDataProvider.Data, XElement)
                    Dim favorites = CType(CType(Resources("MyFavoritesList"), ObjectDataProvider).Data, XElement)
                    msn.ReplaceAll(favorites.Elements("item"))
            End Select
        End Sub

        ''' <summary>
        ''' 鼠标进入或离开时更改颜色或搜索链接，以表示
        ''' 它们是可点击的
        ''' </summary>
        Private Overloads Sub OnMouseEnter(ByVal sender As Object, ByVal e As System.Windows.Input.MouseEventArgs)
            Dim myLabel = CType(sender, Label)
            previousBrush = myLabel.Foreground
            myLabel.Foreground = Brushes.Blue
        End Sub

        Private Overloads Sub OnMouseLeave(ByVal sender As Object, ByVal e As System.Windows.Input.MouseEventArgs)
            Dim myLabel = CType(sender, Label)
            myLabel.Foreground = previousBrush
        End Sub

    End Class
End Namespace
